/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.insulation;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemInsulationCap
implements IInsulatableCap {
    private final List<Pair<ItemStack, Multimap<Insulator, Insulation>>> insulation = new ArrayList<Pair<ItemStack, Multimap<Insulator, Insulation>>>();
    private boolean changed = false;
    private CompoundTag oldSerialized = null;

    @Override
    public List<Pair<ItemStack, Multimap<Insulator, Insulation>>> getInsulation() {
        return this.insulation;
    }

    public void calcAdaptiveInsulation(double worldTemp, double minTemp, double maxTemp) {
        for (Pair<ItemStack, Multimap<Insulator, Insulation>> entry : this.insulation) {
            Collection entryInsul = ((Multimap)entry.getSecond()).values();
            for (Insulation pair : entryInsul) {
                if (!(pair instanceof AdaptiveInsulation)) continue;
                AdaptiveInsulation insul = (AdaptiveInsulation)pair;
                double factor = insul.getFactor();
                double adaptSpeed = insul.getSpeed();
                double newFactor = CSMath.betweenInclusive(CSMath.blend(-1.0, 1.0, worldTemp, minTemp, maxTemp), -0.25, 0.25) ? CSMath.shrink(factor, adaptSpeed) : CSMath.clamp(factor + CSMath.blend(-adaptSpeed, adaptSpeed, worldTemp, minTemp, maxTemp), -1.0, 1.0);
                insul.setFactor(newFactor);
            }
        }
        this.changed = true;
    }

    @Override
    public void addInsulationItem(ItemStack stack) {
        Multimap insulation = ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.m_41720_()).stream().map(insulator -> Map.entry(insulator, insulator.insulation().split())).collect(FastMultiMap::new, (map, o) -> map.putAll((Insulator)o.getKey(), (Iterable)o.getValue()), FastMultiMap::putAll);
        if (!insulation.isEmpty()) {
            this.insulation.add((Pair<ItemStack, Multimap<Insulator, Insulation>>)Pair.of((Object)stack, (Object)insulation));
            this.changed = true;
        }
    }

    @Override
    public ItemStack removeInsulationItem(ItemStack stack) {
        Optional<Pair> toRemove = this.insulation.stream().filter(entry -> ((ItemStack)entry.getFirst()).equals(stack)).findFirst();
        toRemove.ifPresent(pair -> {
            this.insulation.remove(pair);
            this.changed = true;
        });
        return stack;
    }

    @Override
    public ItemStack getInsulationItem(int index) {
        return (ItemStack)this.insulation.get(index).getFirst();
    }

    @Override
    public boolean canAddInsulationItem(ItemStack armorItem, ItemStack insulationItem) {
        AtomicInteger positiveInsul = new AtomicInteger();
        Multimap insulation = ConfigSettings.INSULATION_ITEMS.get().get((Object)insulationItem.m_41720_()).stream().filter(insulator -> insulator.test(null, insulationItem)).map(insulator -> Map.entry(insulator, insulator.insulation().split())).collect(FastMultiMap::new, (map, o) -> map.putAll((Insulator)o.getKey(), (Iterable)o.getValue()), FastMultiMap::putAll);
        if (insulation.isEmpty()) {
            return false;
        }
        ArrayList<Pair<ItemStack, Multimap<Insulator, Insulation>>> insulList = new ArrayList<Pair<ItemStack, Multimap<Insulator, Insulation>>>(this.insulation);
        insulList.add((Pair<ItemStack, Multimap<Insulator, Insulation>>)Pair.of((Object)insulationItem, (Object)insulation));
        insulList.stream().map(Pair::getSecond).flatMap(map -> map.values().stream()).forEach(insul -> {
            if (insul.getHeat() >= 0.0 || insul.getCold() >= 0.0) {
                positiveInsul.getAndIncrement();
            }
        });
        return positiveInsul.get() <= ItemInsulationManager.getInsulationSlots(armorItem);
    }

    public CompoundTag serializeNBT() {
        if (!this.changed && this.oldSerialized != null) {
            return this.oldSerialized;
        }
        ListTag insulNBT = new ListTag();
        for (int i = 0; i < this.insulation.size(); ++i) {
            Pair<ItemStack, Multimap<Insulator, Insulation>> entry = this.insulation.get(i);
            CompoundTag entryNBT = new CompoundTag();
            Multimap pairList = (Multimap)entry.getSecond();
            entryNBT.m_128365_("Item", (Tag)((ItemStack)entry.getFirst()).m_41739_(new CompoundTag()));
            ListTag entryInsulList = new ListTag();
            for (Map.Entry insulMapping : pairList.asMap().entrySet()) {
                CompoundTag mappingNBT = new CompoundTag();
                mappingNBT.m_128365_("Insulator", (Tag)((Insulator)insulMapping.getKey()).serialize());
                mappingNBT.m_128365_("Insulation", (Tag)ItemInsulationCap.serializeInsulation((Collection)insulMapping.getValue()));
                entryInsulList.add((Object)mappingNBT);
            }
            entryNBT.m_128365_("Values", (Tag)entryInsulList);
            insulNBT.add((Object)entryNBT);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Insulation", (Tag)insulNBT);
        this.oldSerialized = tag;
        this.changed = false;
        return tag;
    }

    private static ListTag serializeInsulation(Collection<Insulation> pairList) {
        ListTag insulList = new ListTag();
        for (Insulation insulation : pairList) {
            insulList.add((Object)insulation.serialize());
        }
        return insulList;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.insulation.clear();
        ListTag insulNBT = tag.m_128437_("Insulation", 10);
        for (int i = 0; i < insulNBT.size(); ++i) {
            CompoundTag entryNBT = insulNBT.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)entryNBT.m_128469_("Item"));
            FastMultiMap insulMap = new FastMultiMap();
            ListTag pairListNBT = entryNBT.m_128437_("Values", 10);
            if (!pairListNBT.isEmpty() && !pairListNBT.m_128728_(0).m_128441_("Insulator")) {
                for (Insulator insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.m_41720_())) {
                    insulMap.putAll(insulator, insulator.insulation().split());
                }
            } else {
                for (int j = 0; j < pairListNBT.size(); ++j) {
                    CompoundTag mappingNBT = pairListNBT.m_128728_(j);
                    Insulator insulator = Insulator.deserialize(mappingNBT.m_128469_("Insulator"));
                    ListTag insulListNBT = mappingNBT.m_128437_("Insulation", 10);
                    ArrayList<Insulation> insulList = new ArrayList<Insulation>();
                    for (int k = 0; k < insulListNBT.size(); ++k) {
                        insulList.add(Insulation.deserialize(insulListNBT.m_128728_(k)));
                    }
                    insulMap.putAll(insulator, insulList);
                }
            }
            this.insulation.add((Pair<ItemStack, Multimap<Insulator, Insulation>>)Pair.of((Object)stack, insulMap));
        }
        if (!tag.equals((Object)this.oldSerialized)) {
            this.changed = true;
        }
    }

    @Override
    public void copy(IInsulatableCap cap) {
        this.insulation.clear();
        this.insulation.addAll(cap.getInsulation());
    }
}

